<?php
if ( ! defined('ABSPATH') ) exit;

/**
 * Admin Menu: Easy AI Director
 * - EADテンプレート (list)
 * - テンプレートを追加 (add new)
 * - AI設定
 */
add_action('admin_menu', function () {
  // Top-level menu
  add_menu_page(
    'Easy AI Director',
    'Easy AI Director',
    'edit_posts',
    'easy-ai-director',
    'ead_admin_menu_redirect_to_templates',
    'dashicons-media-text',
    25
  );

  // Templates list
  add_submenu_page(
    'easy-ai-director',
    'EADテンプレート',
    'EADテンプレート',
    'edit_posts',
    'edit.php?post_type=ead_template'
  );

  // Trial版：テンプレ上限(5件)に達したら「テンプレートを追加」を表示しない
  $count = wp_count_posts('ead_template');
  $total = 0;
  foreach (['publish','draft','pending','private','future'] as $st) {
    $total += isset($count->$st) ? (int)$count->$st : 0;
  }
  if ($total < 5) {
    add_submenu_page(
      'easy-ai-director',
      'テンプレートを追加',
      'テンプレートを追加',
      'edit_posts',
      'post-new.php?post_type=ead_template'
    );
  }

  // Remove auto-added duplicate submenu (top-level)
  remove_submenu_page('easy-ai-director', 'easy-ai-director');

  // AI settings
  add_submenu_page(
    'easy-ai-director',
    'AI設定',
    'AI設定',
    'manage_options',
    'ead-ai-settings',
    'ead_render_ai_settings_page'
  );
});

function ead_admin_menu_redirect_to_templates() {
  if ( ! current_user_can('edit_posts') ) return;
  wp_safe_redirect( admin_url('edit.php?post_type=ead_template') );
  exit;
}

add_action('admin_init', function () {
  register_setting('ead_ai_settings_group', 'ead_ai_settings', [
    'type' => 'array',
    'sanitize_callback' => 'ead_sanitize_ai_settings',
    'default' => [
      'gemini_api_key' => '',
      'default_ai'     => 'gemini',
      'gemini_model'   => 'gemini-2.5-flash',
      'creativity'     => 40,
    ],
  ]);
});

function ead_sanitize_ai_settings($input) {
  $out = is_array($input) ? $input : [];

  // Keep existing key if the submitted value looks masked (contains '*')
  $prev = get_option('ead_ai_settings', []);
  $prev_key = (is_array($prev) && isset($prev['gemini_api_key'])) ? (string)$prev['gemini_api_key'] : '';

  $raw_key = isset($out['gemini_api_key']) ? (string)$out['gemini_api_key'] : '';
  if ($raw_key === '' ) {
    // allow clearing
    $out['gemini_api_key'] = '';
  } elseif (strpos($raw_key, '*') !== false) {
    // keep previous real key
    $out['gemini_api_key'] = $prev_key;
  } else {
    $out['gemini_api_key'] = sanitize_text_field($raw_key);
  }

  $out['default_ai'] = isset($out['default_ai']) ? sanitize_text_field($out['default_ai']) : 'gemini';
  $out['gemini_model'] = isset($out['gemini_model']) ? sanitize_text_field($out['gemini_model']) : 'gemini-2.5-flash';

  $c = isset($out['creativity']) ? intval($out['creativity']) : 40;
  if ($c < 0) $c = 0;
  if ($c > 100) $c = 100;
  $out['creativity'] = $c;

  return $out;
}

function ead_get_ai_settings() {
  $opt = get_option('ead_ai_settings', []);
  if (!is_array($opt)) $opt = [];
  $defaults = [
    'gemini_api_key' => '',
    'default_ai'     => 'gemini',
    'gemini_model'   => 'gemini-2.5-flash',
    'creativity'     => 40,
  ];
  return array_merge($defaults, $opt);
}

function ead_render_ai_settings_page() {
  if ( ! current_user_can('manage_options') ) return;
  $opt = ead_get_ai_settings();
  $api_key = (string)($opt['gemini_api_key'] ?? '');
  $masked_key = '';
  if ($api_key !== '') {
    $len = strlen($api_key);
    $last = substr($api_key, -4);
    $masked_key = str_repeat('*', max(0, $len - 4)) . $last;
  }
  ?>
  <div class="wrap">
    <h1>AI設定</h1>

    <h2 class="title">Gemini</h2>
    <form method="post" action="options.php">
      <?php settings_fields('ead_ai_settings_group'); ?>

      <table class="form-table" role="presentation">
        <tr>
          <th scope="row"><label for="ead_gemini_api_key">APIキー</label></th>
          <td>
            <input type="text" class="regular-text" id="ead_gemini_api_key"
              name="ead_ai_settings[gemini_api_key]" value="<?php echo esc_attr($masked_key); ?>" />
            <p class="description">Google AI Studio で発行した Gemini API Key を入力してください（表示は末尾4文字のみ）。</p>
          </td>
        </tr>

        <tr>
          <th scope="row">デフォルトAI</th>
          <td>
            <p class="description">投稿やテンプレートのAI設定の初期値を設定します。</p>

            <label for="ead_default_ai" style="display:block; margin-top:6px;">AI選択</label>
            <select id="ead_default_ai" name="ead_ai_settings[default_ai]">
              <option value="gemini" <?php selected($opt['default_ai'], 'gemini'); ?>>Gemini</option>
            </select>

            <label for="ead_gemini_model" style="display:block; margin-top:10px;">モデル選択</label>
            <select id="ead_gemini_model" name="ead_ai_settings[gemini_model]">
              <option value="gemini-2.5-flash" <?php selected($opt['gemini_model'], 'gemini-2.5-flash'); ?>>gemini-2.5-flash</option>
              <option value="gemini-2.5-pro" <?php selected($opt['gemini_model'], 'gemini-2.5-pro'); ?>>gemini-2.5-pro</option>
            </select>


            <!-- 文章の自由度（サイト全体の既定値）は混乱を避けるため削除。
                 テンプレート/記事側の設定を利用してください。 -->
          </td>
        </tr>
      </table>

      <?php submit_button(); ?>
    </form>
  </div>
  <?php
}
